//toolbox_demo.c

library "PToolboxLib"

DisplayMaze(int maze_cols, int maze_rows);

main() {
int x,y,array[12];

Handera(1,1); //enable hi-res on Handeras

//Show a 4 bit bitmap
SetDepth(4);
graph_on();
ClearBuf();

text(62,1,"Triangles");
for(x=0;x<16;x++) {
	SetFore(x);
	tri(1,(x*10)-5,80,5+(x*10),80,80,15);
}

if(!dbtotalsize("test_bitmap")) {
  alert("Failed to find test_bitmap.prc!");
  return;
}
OpenBmpDb("test_bitmap");

FastBmp(55,90,3);
text(35,145,"4 Bit Grayscale Bitmap");
while(event(1) != 2);
graph_off();

//Change depth to 2 bit mode
SetDepth(2);
graph_on();
//SetPalette(0,3,4,7);
ClearBuf();

// FILL PATTERNS & ROTATION
SetFore(1);
SetBack(2);
SetPattern("ffaaffaaffaaffaa"); //grid pattern
ellipse(3,55,90,25,40);
SetFore(3);
SetBack(2);
SetPattern("aa11aa44aa11aa44"); //diags pattern
Rect(4,110,10,150,130,0);

SetPattern("8811224488112244"); //diags pattern
SetBack(1);
array[0]=25; array[1]=5;
array[2]=75; array[3]=10;
array[4]=95; array[5]=60;
array[6]=70; array[7]=30;
array[8]=40; array[9]=20;
array[10]=20; array[11]=50;
Lines(3,array,12);

FloodFill(3,30,10);

SetBack(0);
text(10,145,"Custom fill patterns & a rotation");

CopyRect(0,0,5,10,145,140,12,0,0,3);
while(event(1) != 2);


//SCROLLING
x=140;
while(x--) {
	ScrollRect(9,145,140,12,0x3,1);
	sleep(20);
}
text(60,145,"Scrolling!");
CopyBuf(3,0); //copy screen (buffer 0) to buffer 3
while(event(1) != 2);


ClearBuf();
rect(0,0,0,160,50,0); //blank out title

//MAZE GENERATION
pseed(7); // maze will always be the same
x=49; // maze columns
y=49; // maze rows

MakeMaze(x,y,80,0,0,0,100,0,50);

DisplayMaze(x,y); //This takes a long time
text(5,148,"Maze Generation");
OpenBufDb("mazedb",2);
SaveBuf(0); //save maze away 
while(event(1) != 2);


//SHOW SOME BITMAPS & GRAYSCALE GRAPHICS
SetDrawBuf(1); // draw bitmaps in scratch buffer 1

text(120,30,"Zooming!");
FastBmp(128,45,0); // a grayscale bitmap
CopyRect(1,120,70,128,45,16,16,0,2,0); // copy,invert, and X2 zoom the gray bitmap
CopyRect(1,112,112,128,45,16,16,0,3,0); // copy,invert, and X2 zoom the gray bitmap
CopyRect(1,80,45,128,45,16,16,0,-2,0); // copy,invert, and X2 zoom the gray bitmap
text(35,77,"Normal Bitmap");
text(35,97,"Transparent Bitmap");

//Draw some other gray stuff
SetFore(1);
SetTextColor(1); //for OS3.5
SetBack(2);

line(1,0,135,80,159);
line(1,159,80,80,159);
rect(1,5,70,31,130,0);
FastBmp(10,75,1);
TransBmp(10,95,1,2);

text(60,10," GRAYSCALE GRAPHICS");
SetPixel(70,60);
SetFore(3);
SetPixel(70,61);

// Embed circles in a black square
SetFore(3);
rect(1,5,5,45,45,0);
SetFore(2);
rect(1,10,10,40,40,15);
SetFore(1);
rect(1,15,15,35,35,10);
SetFore(0);
rect(1,20,20,30,30,5);

//Put maze from database into buffer 2
SetDrawBuf(2);
RestoreBuf(0);

// Toggle between displaying buffers 1 & 2
while(1) {
	CopyBuf(0,1);
	while(event(1) != 2);
	CopyBuf(0,2);
	while(event(1) != 2);
	CopyBuf(0,3);
	while(event(1) != 2);	
}

graph_off();
exit();
}

DisplayMaze(int maze_cols, int maze_rows) {
	int x,y,square_size;
	
	if(maze_rows > maze_cols) square_size = 150 / maze_rows;
	else square_size = 150 / maze_cols;	
	
	y=maze_rows;while(y--) {
		x=maze_cols;while(x--) {
			if(GetMaze(x,y)) {		
				rect(1, x*square_size, y*square_size, (x+1)*square_size, (y+1)*square_size, 0);
			}
		}
	}
}